/*
 * Decompiled with CFR 0.152.
 */
package Test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class JavaFX {
    private static final Logger logger = Logger.getLogger(JavaFX.class.getName());

    private static void initAndShowGUI() {
        JFrame frame = new JFrame("FX");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(null);
        JButton jButton = new JButton("Button");
        final JFXPanel fxPanel = new JFXPanel();
        frame.add(jButton);
        frame.add((Component)fxPanel);
        frame.setVisible(true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        jButton.setSize(new Dimension(200, 27));
        fxPanel.setSize(dim);
        fxPanel.setLocation(new Point(0, 27));
        frame.getContentPane().setPreferredSize(dim);
        frame.pack();
        frame.setResizable(false);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JavaFX.initFX(fxPanel);
                }
                catch (Exception ex) {
                    logger.error("Exception", ex);
                }
            }
        });
    }

    public static String getContent(String htmlFile) {
        try {
            String line;
            BufferedReader reader = Files.newBufferedReader(new File(htmlFile).toPath(), StandardCharsets.UTF_8);
            String result = "";
            while ((line = reader.readLine()) != null) {
                result = result + line + "\n";
            }
            return result;
        }
        catch (Exception ex) {
            logger.error("Exception", ex);
            return "";
        }
    }

    private static void initFX(JFXPanel fxPanel) throws Exception {
        StackPane group = new StackPane();
        Scene scene = new Scene((Parent)group);
        fxPanel.setScene(scene);
        WebView webView = new WebView();
        group.getChildren().add((Object)webView);
        webView.setMinSize(300.0, 300.0);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        webView.setMaxSize((double)dim.width, (double)dim.height);
        WebEngine webEngine = webView.getEngine();
        URL url = new File("D:\\Users\\dungnv93\\Documents\\NetBeansProjects\\sd-dss-master\\sd-dss-master\\dss-token\\src\\main\\resources\\Html\\test.html").toURI().toURL();
        webEngine.load(url.toExternalForm());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaFX.initAndShowGUI();
            }
        });
    }
}

