/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.SocketException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.InputRecord;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.PostHandshakeContext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SSLTransport;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;

class TransportContext
implements ConnectionContext {
    final SSLTransport transport;
    final Map<Byte, SSLConsumer> consumers;
    final AccessControlContext acc;
    final SSLContextImpl sslContext;
    final SSLConfiguration sslConfig;
    final InputRecord inputRecord;
    final OutputRecord outputRecord;
    boolean isUnsureMode;
    boolean isNegotiated = false;
    boolean isBroken = false;
    boolean isInputCloseNotified = false;
    boolean peerUserCanceled = false;
    Exception closeReason = null;
    Exception delegatedThrown = null;
    boolean needHandshakeFinishedStatus = false;
    boolean hasDelegatedFinished = false;
    SSLSessionImpl conSession;
    ProtocolVersion protocolVersion;
    String applicationProtocol = null;
    HandshakeContext handshakeContext = null;
    boolean secureRenegotiation = false;
    byte[] clientVerifyData;
    byte[] serverVerifyData;
    List<SupportedGroupsExtension.NamedGroup> serverRequestedNamedGroups;
    CipherSuite cipherSuite;
    private static final byte[] emptyByteArray = new byte[0];

    TransportContext(SSLContextImpl sSLContextImpl, SSLTransport sSLTransport, InputRecord inputRecord, OutputRecord outputRecord) {
        this(sSLContextImpl, sSLTransport, new SSLConfiguration(sSLContextImpl, false), inputRecord, outputRecord, true);
    }

    TransportContext(SSLContextImpl sSLContextImpl, SSLTransport sSLTransport, InputRecord inputRecord, OutputRecord outputRecord, boolean bl) {
        this(sSLContextImpl, sSLTransport, new SSLConfiguration(sSLContextImpl, bl), inputRecord, outputRecord, false);
    }

    TransportContext(SSLContextImpl sSLContextImpl, SSLTransport sSLTransport, SSLConfiguration sSLConfiguration, InputRecord inputRecord, OutputRecord outputRecord) {
        this(sSLContextImpl, sSLTransport, (SSLConfiguration)sSLConfiguration.clone(), inputRecord, outputRecord, false);
    }

    private TransportContext(SSLContextImpl sSLContextImpl, SSLTransport sSLTransport, SSLConfiguration sSLConfiguration, InputRecord inputRecord, OutputRecord outputRecord, boolean bl) {
        this.transport = sSLTransport;
        this.sslContext = sSLContextImpl;
        this.inputRecord = inputRecord;
        this.outputRecord = outputRecord;
        this.sslConfig = sSLConfiguration;
        if (this.sslConfig.maximumPacketSize == 0) {
            this.sslConfig.maximumPacketSize = outputRecord.getMaxPacketSize();
        }
        this.isUnsureMode = bl;
        this.conSession = new SSLSessionImpl();
        this.protocolVersion = this.sslConfig.maximumProtocolVersion;
        this.clientVerifyData = emptyByteArray;
        this.serverVerifyData = emptyByteArray;
        this.acc = AccessController.getContext();
        this.consumers = new HashMap<Byte, SSLConsumer>();
    }

    void dispatch(Plaintext plaintext) throws IOException {
        if (plaintext == null) {
            return;
        }
        ContentType contentType = ContentType.valueOf(plaintext.contentType);
        if (contentType == null) {
            throw this.fatal(Alert.UNEXPECTED_MESSAGE, "Unknown content type: " + plaintext.contentType);
        }
        switch (contentType) {
            case HANDSHAKE: {
                byte by = HandshakeContext.getHandshakeType(this, plaintext);
                if (this.handshakeContext == null) {
                    if (by == SSLHandshake.KEY_UPDATE.id || by == SSLHandshake.NEW_SESSION_TICKET.id) {
                        if (!this.isNegotiated) {
                            throw this.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected unnegotiated post-handshake message: " + SSLHandshake.nameOf(by));
                        }
                        if (!PostHandshakeContext.isConsumable(this, by)) {
                            throw this.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected post-handshake message: " + SSLHandshake.nameOf(by));
                        }
                        this.handshakeContext = new PostHandshakeContext(this);
                    } else {
                        this.handshakeContext = this.sslConfig.isClientMode ? new ClientHandshakeContext(this.sslContext, this) : new ServerHandshakeContext(this.sslContext, this);
                        this.outputRecord.initHandshaker();
                    }
                }
                this.handshakeContext.dispatch(by, plaintext);
                break;
            }
            case ALERT: {
                Alert.alertConsumer.consume(this, plaintext.fragment);
                break;
            }
            default: {
                SSLConsumer sSLConsumer = this.consumers.get(plaintext.contentType);
                if (sSLConsumer != null) {
                    sSLConsumer.consume(this, plaintext.fragment);
                    break;
                }
                throw this.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected content: " + plaintext.contentType);
            }
        }
    }

    void kickstart() throws IOException {
        boolean bl;
        if (this.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode not yet set.");
        }
        boolean bl2 = this.outputRecord.writeCipher.atKeyLimit() ? this.outputRecord.isClosed() || this.isBroken : (bl = this.outputRecord.isClosed() || this.inputRecord.isClosed() || this.isBroken);
        if (bl) {
            if (this.closeReason != null) {
                throw new SSLException("Cannot kickstart, the connection is broken or closed", this.closeReason);
            }
            throw new SSLException("Cannot kickstart, the connection is broken or closed");
        }
        if (this.handshakeContext == null) {
            if (this.isNegotiated && this.protocolVersion.useTLS13PlusSpec()) {
                this.handshakeContext = new PostHandshakeContext(this);
            } else {
                this.handshakeContext = this.sslConfig.isClientMode ? new ClientHandshakeContext(this.sslContext, this) : new ServerHandshakeContext(this.sslContext, this);
                this.outputRecord.initHandshaker();
            }
        }
        if (this.isNegotiated || this.sslConfig.isClientMode) {
            this.handshakeContext.kickstart();
        }
    }

    boolean isPostHandshakeContext() {
        return this.handshakeContext != null && this.handshakeContext instanceof PostHandshakeContext;
    }

    void warning(Alert alert) {
        block3: {
            if (this.isNegotiated || this.handshakeContext != null) {
                try {
                    this.outputRecord.encodeAlert(Alert.Level.WARNING.level, alert.id);
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block3;
                    SSLLogger.warning("Warning: failed to send warning alert " + (Object)((Object)alert), iOException);
                }
            }
        }
    }

    void closeNotify(boolean bl) throws IOException {
        if (this.transport instanceof SSLSocketImpl) {
            ((SSLSocketImpl)this.transport).closeNotify(bl);
        } else {
            this.outputRecord.recordLock.lock();
            try {
                try {
                    if (bl) {
                        this.warning(Alert.USER_CANCELED);
                    }
                    this.warning(Alert.CLOSE_NOTIFY);
                }
                finally {
                    this.outputRecord.close();
                }
            }
            finally {
                this.outputRecord.recordLock.unlock();
            }
        }
    }

    SSLException fatal(Alert alert, String string) throws SSLException {
        return this.fatal(alert, string, null);
    }

    SSLException fatal(Alert alert, Throwable throwable) throws SSLException {
        return this.fatal(alert, null, throwable);
    }

    SSLException fatal(Alert alert, String string, Throwable throwable) throws SSLException {
        return this.fatal(alert, string, false, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLException fatal(Alert alert, String string, boolean bl, Throwable throwable) throws SSLException {
        if (this.closeReason != null) {
            if (throwable == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("Closed transport, general or untracked problem", new Object[0]);
                }
                throw alert.createSSLException("Closed transport, general or untracked problem");
            }
            if (throwable instanceof SSLException) {
                throw (SSLException)throwable;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("Closed transport, unexpected rethrowing", throwable);
            }
            throw alert.createSSLException("Unexpected rethrowing", throwable);
        }
        if (string == null) {
            string = throwable == null ? "General/Untracked problem" : throwable.toString();
        }
        if (throwable == null) {
            throwable = alert.createSSLException(string);
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.severe("Fatal (" + (Object)((Object)alert) + "): " + string, throwable);
        }
        this.closeReason = throwable instanceof SSLException ? (SSLException)throwable : alert.createSSLException(string, throwable);
        try {
            this.inputRecord.close();
        }
        catch (IOException iOException) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("Fatal: input record closure failed", iOException);
            }
            this.closeReason.addSuppressed(iOException);
        }
        if (this.conSession != null && !(throwable instanceof SocketException)) {
            this.conSession.invalidate();
        }
        if (this.handshakeContext != null && this.handshakeContext.handshakeSession != null) {
            this.handshakeContext.handshakeSession.invalidate();
        }
        if (!(bl || this.isOutboundClosed() || this.isBroken || !this.isNegotiated && this.handshakeContext == null)) {
            try {
                this.outputRecord.encodeAlert(Alert.Level.FATAL.level, alert.id);
            }
            catch (IOException iOException) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("Fatal: failed to send fatal alert " + (Object)((Object)alert), iOException);
                }
                this.closeReason.addSuppressed(iOException);
            }
        }
        try {
            this.outputRecord.close();
        }
        catch (IOException iOException) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("Fatal: output record closure failed", iOException);
            }
            this.closeReason.addSuppressed(iOException);
        }
        if (this.handshakeContext != null) {
            this.handshakeContext = null;
        }
        try {
            this.transport.shutdown();
        }
        catch (IOException iOException) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("Fatal: transport closure failed", iOException);
            }
            this.closeReason.addSuppressed(iOException);
        }
        finally {
            this.isBroken = true;
        }
        if (this.closeReason instanceof SSLException) {
            throw (SSLException)this.closeReason;
        }
        throw (RuntimeException)this.closeReason;
    }

    void setUseClientMode(boolean bl) {
        if (this.handshakeContext != null || this.isNegotiated) {
            throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
        }
        if (this.sslConfig.isClientMode != bl) {
            if (this.sslContext.isDefaultProtocolVesions(this.sslConfig.enabledProtocols)) {
                this.sslConfig.enabledProtocols = this.sslContext.getDefaultProtocolVersions(!bl);
            }
            if (this.sslContext.isDefaultCipherSuiteList(this.sslConfig.enabledCipherSuites)) {
                this.sslConfig.enabledCipherSuites = this.sslContext.getDefaultCipherSuites(!bl);
            }
            this.sslConfig.toggleClientMode();
        }
        this.isUnsureMode = false;
    }

    boolean isOutboundDone() {
        return this.outputRecord.isClosed() && this.outputRecord.isEmpty();
    }

    boolean isOutboundClosed() {
        return this.outputRecord.isClosed();
    }

    boolean isInboundClosed() {
        return this.inputRecord.isClosed();
    }

    void closeInbound() throws SSLException {
        block5: {
            if (this.isInboundClosed()) {
                return;
            }
            try {
                if (!this.isInputCloseNotified) {
                    this.initiateInboundClose();
                } else {
                    this.passiveInboundClose();
                }
            }
            catch (IOException iOException) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block5;
                SSLLogger.warning("inbound closure failed", iOException);
            }
        }
    }

    private void passiveInboundClose() throws IOException {
        if (!this.isInboundClosed()) {
            this.inputRecord.close();
        }
        if (!this.isOutboundClosed()) {
            boolean bl = SSLConfiguration.acknowledgeCloseNotify;
            if (!bl) {
                ProtocolVersion protocolVersion;
                if (this.isNegotiated) {
                    if (!this.protocolVersion.useTLS13PlusSpec()) {
                        bl = true;
                    }
                } else if (!(this.handshakeContext == null || (protocolVersion = this.handshakeContext.negotiatedProtocol) != null && protocolVersion.useTLS13PlusSpec())) {
                    bl = true;
                }
            }
            if (bl) {
                this.closeNotify(false);
            }
        }
    }

    private void initiateInboundClose() throws IOException {
        if (!this.isInboundClosed()) {
            this.inputRecord.close();
        }
    }

    void closeOutbound() {
        block3: {
            if (this.isOutboundClosed()) {
                return;
            }
            try {
                this.initiateOutboundClose();
            }
            catch (IOException iOException) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block3;
                SSLLogger.warning("outbound closure failed", iOException);
            }
        }
    }

    private void initiateOutboundClose() throws IOException {
        boolean bl = false;
        if (!this.isNegotiated && this.handshakeContext != null && !this.peerUserCanceled) {
            bl = true;
        }
        this.closeNotify(bl);
    }

    SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (!this.outputRecord.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.isOutboundClosed() && this.isInboundClosed()) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (this.handshakeContext != null) {
            if (!this.handshakeContext.delegatedActions.isEmpty()) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            if (!this.isInboundClosed()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            if (!this.isOutboundClosed()) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
        } else if (this.needHandshakeFinishedStatus) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    SSLEngineResult.HandshakeStatus finishHandshake() {
        if (this.protocolVersion.useTLS13PlusSpec()) {
            this.outputRecord.tc = this;
            this.inputRecord.tc = this;
            this.cipherSuite = this.handshakeContext.negotiatedCipherSuite;
            this.inputRecord.readCipher.baseSecret = this.handshakeContext.baseReadSecret;
            this.outputRecord.writeCipher.baseSecret = this.handshakeContext.baseWriteSecret;
        }
        this.handshakeContext = null;
        this.outputRecord.handshakeHash.finish();
        this.isNegotiated = true;
        if (this.transport instanceof SSLSocket && this.sslConfig.handshakeListeners != null && !this.sslConfig.handshakeListeners.isEmpty()) {
            HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent((SSLSocket)((Object)this.transport), this.conSession);
            Thread thread = new Thread(null, new NotifyHandshake(this.sslConfig.handshakeListeners, handshakeCompletedEvent), "HandshakeCompletedNotify-Thread", 0L);
            thread.start();
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    SSLEngineResult.HandshakeStatus finishPostHandshake() {
        this.handshakeContext = null;
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private static class NotifyHandshake
    implements Runnable {
        private final Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> targets;
        private final HandshakeCompletedEvent event;

        NotifyHandshake(Map<HandshakeCompletedListener, AccessControlContext> map, HandshakeCompletedEvent handshakeCompletedEvent) {
            this.targets = new HashSet<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(map.entrySet());
            this.event = handshakeCompletedEvent;
        }

        @Override
        public void run() {
            for (Map.Entry<HandshakeCompletedListener, AccessControlContext> entry : this.targets) {
                final HandshakeCompletedListener handshakeCompletedListener = entry.getKey();
                AccessControlContext accessControlContext = entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        handshakeCompletedListener.handshakeCompleted(event);
                        return null;
                    }
                }, accessControlContext);
            }
        }
    }
}

