/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.Utilities;

final class SSLConfiguration
implements Cloneable {
    AlgorithmConstraints userSpecifiedAlgorithmConstraints = SSLAlgorithmConstraints.DEFAULT;
    List<ProtocolVersion> enabledProtocols;
    List<CipherSuite> enabledCipherSuites;
    ClientAuthType clientAuthType;
    String identificationProtocol;
    List<SNIServerName> serverNames;
    Collection<SNIMatcher> sniMatchers;
    String[] applicationProtocols;
    boolean preferLocalCipherSuites;
    int maximumPacketSize;
    List<SignatureScheme> signatureSchemes;
    ProtocolVersion maximumProtocolVersion;
    boolean isClientMode;
    boolean enableSessionCreation;
    BiFunction<SSLSocket, List<String>, String> socketAPSelector;
    BiFunction<SSLEngine, List<String>, String> engineAPSelector;
    HashMap<HandshakeCompletedListener, AccessControlContext> handshakeListeners;
    boolean noSniExtension;
    boolean noSniMatcher;
    static final boolean useExtendedMasterSecret;
    static final boolean allowLegacyResumption;
    static final boolean allowLegacyMasterSecret;
    static final boolean useCompatibilityMode;
    static final boolean acknowledgeCloseNotify;
    static final int maxHandshakeMessageSize;
    static final int maxCertificateChainLength;

    SSLConfiguration(SSLContextImpl sSLContextImpl, boolean bl) {
        this.enabledProtocols = sSLContextImpl.getDefaultProtocolVersions(!bl);
        this.enabledCipherSuites = sSLContextImpl.getDefaultCipherSuites(!bl);
        this.clientAuthType = ClientAuthType.CLIENT_AUTH_NONE;
        this.identificationProtocol = null;
        this.serverNames = Collections.emptyList();
        this.sniMatchers = Collections.emptyList();
        this.preferLocalCipherSuites = true;
        this.applicationProtocols = new String[0];
        this.maximumPacketSize = 0;
        this.signatureSchemes = bl ? CustomizedClientSignatureSchemes.signatureSchemes : CustomizedServerSignatureSchemes.signatureSchemes;
        this.maximumProtocolVersion = ProtocolVersion.NONE;
        for (ProtocolVersion protocolVersion : this.enabledProtocols) {
            if (protocolVersion.compareTo(this.maximumProtocolVersion) <= 0) continue;
            this.maximumProtocolVersion = protocolVersion;
        }
        this.isClientMode = bl;
        this.enableSessionCreation = true;
        this.socketAPSelector = null;
        this.engineAPSelector = null;
        this.handshakeListeners = null;
        this.noSniExtension = false;
        this.noSniMatcher = false;
    }

    SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setAlgorithmConstraints(this.userSpecifiedAlgorithmConstraints);
        sSLParameters.setProtocols(ProtocolVersion.toStringArray(this.enabledProtocols));
        sSLParameters.setCipherSuites(CipherSuite.namesOf(this.enabledCipherSuites));
        switch (this.clientAuthType) {
            case CLIENT_AUTH_REQUIRED: {
                sSLParameters.setNeedClientAuth(true);
                break;
            }
            case CLIENT_AUTH_REQUESTED: {
                sSLParameters.setWantClientAuth(true);
                break;
            }
            default: {
                sSLParameters.setWantClientAuth(false);
            }
        }
        sSLParameters.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        if (this.serverNames.isEmpty() && !this.noSniExtension) {
            sSLParameters.setServerNames(null);
        } else {
            sSLParameters.setServerNames(this.serverNames);
        }
        if (this.sniMatchers.isEmpty() && !this.noSniMatcher) {
            sSLParameters.setSNIMatchers(null);
        } else {
            sSLParameters.setSNIMatchers(this.sniMatchers);
        }
        sSLParameters.setApplicationProtocols(this.applicationProtocols);
        sSLParameters.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        return sSLParameters;
    }

    void setSSLParameters(SSLParameters sSLParameters) {
        Collection<SNIMatcher> collection;
        List<SNIServerName> list;
        String[] stringArray;
        AlgorithmConstraints algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        if (algorithmConstraints != null) {
            this.userSpecifiedAlgorithmConstraints = algorithmConstraints;
        }
        if ((stringArray = sSLParameters.getCipherSuites()) != null) {
            this.enabledCipherSuites = CipherSuite.validValuesOf(stringArray);
        }
        if ((stringArray = sSLParameters.getProtocols()) != null) {
            this.enabledProtocols = ProtocolVersion.namesOf(stringArray);
            this.maximumProtocolVersion = ProtocolVersion.NONE;
            for (ProtocolVersion object2 : this.enabledProtocols) {
                if (object2.compareTo(this.maximumProtocolVersion) <= 0) continue;
                this.maximumProtocolVersion = object2;
            }
        }
        this.clientAuthType = sSLParameters.getNeedClientAuth() ? ClientAuthType.CLIENT_AUTH_REQUIRED : (sSLParameters.getWantClientAuth() ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE);
        String string = sSLParameters.getEndpointIdentificationAlgorithm();
        if (string != null) {
            this.identificationProtocol = string;
        }
        if ((list = sSLParameters.getServerNames()) != null) {
            this.noSniExtension = list.isEmpty();
            this.serverNames = list;
        }
        if ((collection = sSLParameters.getSNIMatchers()) != null) {
            this.noSniMatcher = collection.isEmpty();
            this.sniMatchers = collection;
        }
        if ((stringArray = sSLParameters.getApplicationProtocols()) != null) {
            this.applicationProtocols = stringArray;
        }
        this.preferLocalCipherSuites = sSLParameters.getUseCipherSuitesOrder();
    }

    void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(handshakeCompletedListener, AccessController.getContext());
    }

    void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(handshakeCompletedListener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    boolean isAvailable(SSLExtension sSLExtension) {
        for (ProtocolVersion protocolVersion : this.enabledProtocols) {
            if (!sSLExtension.isAvailable(protocolVersion) || !(this.isClientMode ? SSLExtension.ClientExtensions.defaults.contains(sSLExtension) : SSLExtension.ServerExtensions.defaults.contains(sSLExtension))) continue;
            return true;
        }
        return false;
    }

    boolean isAvailable(SSLExtension sSLExtension, ProtocolVersion protocolVersion) {
        return sSLExtension.isAvailable(protocolVersion) && (this.isClientMode ? SSLExtension.ClientExtensions.defaults.contains(sSLExtension) : SSLExtension.ServerExtensions.defaults.contains(sSLExtension));
    }

    SSLExtension[] getEnabledExtensions(SSLHandshake sSLHandshake) {
        ArrayList<SSLExtension> arrayList = new ArrayList<SSLExtension>();
        for (SSLExtension sSLExtension : SSLExtension.values()) {
            if (sSLExtension.handshakeType != sSLHandshake || !this.isAvailable(sSLExtension)) continue;
            arrayList.add(sSLExtension);
        }
        return arrayList.toArray(new SSLExtension[0]);
    }

    SSLExtension[] getExclusiveExtensions(SSLHandshake sSLHandshake, List<SSLExtension> list) {
        ArrayList<SSLExtension> arrayList = new ArrayList<SSLExtension>();
        for (SSLExtension sSLExtension : SSLExtension.values()) {
            if (sSLExtension.handshakeType != sSLHandshake || !this.isAvailable(sSLExtension) || list.contains(sSLExtension)) continue;
            arrayList.add(sSLExtension);
        }
        return arrayList.toArray(new SSLExtension[0]);
    }

    SSLExtension[] getEnabledExtensions(SSLHandshake sSLHandshake, ProtocolVersion protocolVersion) {
        return this.getEnabledExtensions(sSLHandshake, Arrays.asList(protocolVersion));
    }

    SSLExtension[] getEnabledExtensions(SSLHandshake sSLHandshake, List<ProtocolVersion> list) {
        ArrayList<SSLExtension> arrayList = new ArrayList<SSLExtension>();
        block0: for (SSLExtension sSLExtension : SSLExtension.values()) {
            if (sSLExtension.handshakeType != sSLHandshake || !this.isAvailable(sSLExtension)) continue;
            for (ProtocolVersion protocolVersion : list) {
                if (!sSLExtension.isAvailable(protocolVersion)) continue;
                arrayList.add(sSLExtension);
                continue block0;
            }
        }
        return arrayList.toArray(new SSLExtension[0]);
    }

    void toggleClientMode() {
        this.isClientMode ^= true;
        this.signatureSchemes = this.isClientMode ? CustomizedClientSignatureSchemes.signatureSchemes : CustomizedServerSignatureSchemes.signatureSchemes;
    }

    public Object clone() {
        try {
            SSLConfiguration sSLConfiguration = (SSLConfiguration)super.clone();
            if (this.handshakeListeners != null) {
                sSLConfiguration.handshakeListeners = (HashMap)this.handshakeListeners.clone();
            }
            return sSLConfiguration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private static List<SignatureScheme> getCustomizedSignatureScheme(String string) {
        String string2 = GetPropertyAction.privilegedGetProperty(string);
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,sslctx")) {
            SSLLogger.fine("System property " + string + " is set to '" + string2 + "'", new Object[0]);
        }
        if (string2 != null && !string2.isEmpty() && string2.length() > 1 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2 != null && !string2.isEmpty()) {
            String[] stringArray = string2.split(",");
            ArrayList<SignatureScheme> arrayList = new ArrayList<SignatureScheme>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].isEmpty()) continue;
                SignatureScheme signatureScheme = SignatureScheme.nameOf(stringArray[i]);
                if (signatureScheme != null && signatureScheme.isAvailable) {
                    arrayList.add(signatureScheme);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,sslctx")) continue;
                SSLLogger.fine("The current installed providers do not support signature scheme: " + stringArray[i], new Object[0]);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    static /* synthetic */ List access$200(String string) {
        return SSLConfiguration.getCustomizedSignatureScheme(string);
    }

    static {
        allowLegacyResumption = Utilities.getBooleanProperty("jdk.tls.allowLegacyResumption", true);
        allowLegacyMasterSecret = Utilities.getBooleanProperty("jdk.tls.allowLegacyMasterSecret", true);
        useCompatibilityMode = Utilities.getBooleanProperty("jdk.tls.client.useCompatibilityMode", true);
        acknowledgeCloseNotify = Utilities.getBooleanProperty("jdk.tls.acknowledgeCloseNotify", false);
        maxHandshakeMessageSize = AccessController.doPrivileged(new GetIntegerAction("jdk.tls.maxHandshakeMessageSize", 32768));
        maxCertificateChainLength = AccessController.doPrivileged(new GetIntegerAction("jdk.tls.maxCertificateChainLength", 10));
        boolean bl = Utilities.getBooleanProperty("jdk.tls.useExtendedMasterSecret", true);
        if (bl) {
            try {
                JsseJce.getKeyGenerator("SunTlsExtendedMasterSecret");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                bl = false;
            }
        }
        useExtendedMasterSecret = bl;
    }

    private static final class CustomizedServerSignatureSchemes {
        private static List<SignatureScheme> signatureSchemes = SSLConfiguration.access$200("jdk.tls.server.SignatureSchemes");

        private CustomizedServerSignatureSchemes() {
        }
    }

    private static final class CustomizedClientSignatureSchemes {
        private static List<SignatureScheme> signatureSchemes = SSLConfiguration.access$200("jdk.tls.client.SignatureSchemes");

        private CustomizedClientSignatureSchemes() {
        }
    }
}

