/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import java.util.Arrays;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private static final long serialVersionUID = 3437177836797504046L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        return this.q;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    @Deprecated
    public AlgIdDSA() {
    }

    AlgIdDSA(DerValue derValue) throws IOException {
        super(derValue.getOID());
    }

    public AlgIdDSA(byte[] byArray) throws IOException {
        super(new DerValue(byArray).getOID());
    }

    public AlgIdDSA(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this(new BigInteger(1, byArray), new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public AlgIdDSA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(DSA_oid);
        if (bigInteger != null || bigInteger2 != null || bigInteger3 != null) {
            if (bigInteger == null || bigInteger2 == null || bigInteger3 == null) {
                throw new ProviderException("Invalid parameters for DSS/DSA Algorithm ID");
            }
            try {
                this.p = bigInteger;
                this.q = bigInteger2;
                this.g = bigInteger3;
                this.encodedParams = AlgIdDSA.encode(bigInteger, bigInteger2, bigInteger3);
            }
            catch (IOException iOException) {
                throw new ProviderException("Construct DSS/DSA Algorithm ID");
            }
        }
    }

    @Override
    public String getName() {
        return "DSA";
    }

    @Override
    public String toString() {
        return this.paramsToString();
    }

    @Override
    protected String paramsToString() {
        if (this.encodedParams == null) {
            return " null\n";
        }
        return "\n    p:\n" + Debug.toHexString(this.p) + "\n    q:\n" + Debug.toHexString(this.q) + "\n    g:\n" + Debug.toHexString(this.g) + "\n";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (!(this.p == null && this.q == null && this.g == null && this.encodedParams == null || Arrays.equals(this.encodedParams, AlgIdDSA.encode(this.p, this.q, this.g)))) {
                throw new InvalidObjectException("Invalid DSA alg params");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
    }

    private static byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws IOException {
        if (bigInteger == null || bigInteger2 == null || bigInteger3 == null) {
            throw new InvalidObjectException("invalid null value");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(bigInteger);
        derOutputStream.putInteger(bigInteger2);
        derOutputStream.putInteger(bigInteger3);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    private static class DSAComponents {
        private final BigInteger p;
        private final BigInteger q;
        private final BigInteger g;

        DSAComponents(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.p = bigInteger;
            this.q = bigInteger2;
            this.g = bigInteger3;
        }
    }
}

