/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.URL;
import java.security.cert.X509Certificate;

public final class HttpCallerInfo {
    public final URL url;
    public final String host;
    public final String protocol;
    public final String prompt;
    public final String scheme;
    public final int port;
    public final InetAddress addr;
    public final Authenticator.RequestorType authType;
    public final X509Certificate serverCert;

    public HttpCallerInfo(HttpCallerInfo httpCallerInfo, String string) {
        this.url = httpCallerInfo.url;
        this.host = httpCallerInfo.host;
        this.protocol = httpCallerInfo.protocol;
        this.prompt = httpCallerInfo.prompt;
        this.port = httpCallerInfo.port;
        this.addr = httpCallerInfo.addr;
        this.authType = httpCallerInfo.authType;
        this.scheme = string;
        this.serverCert = httpCallerInfo.serverCert;
    }

    public HttpCallerInfo(URL uRL) {
        this(uRL, null);
    }

    public HttpCallerInfo(URL uRL, X509Certificate x509Certificate) {
        InetAddress inetAddress;
        this.url = uRL;
        this.serverCert = x509Certificate;
        this.prompt = "";
        this.host = uRL.getHost();
        int n = uRL.getPort();
        this.port = n == -1 ? uRL.getDefaultPort() : n;
        try {
            inetAddress = InetAddress.getByName(uRL.getHost());
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        this.addr = inetAddress;
        this.protocol = uRL.getProtocol();
        this.authType = Authenticator.RequestorType.SERVER;
        this.scheme = "";
    }

    public HttpCallerInfo(URL uRL, String string, int n) {
        this(uRL, string, n, null);
    }

    public HttpCallerInfo(URL uRL, String string, int n, X509Certificate x509Certificate) {
        this.url = uRL;
        this.host = string;
        this.port = n;
        this.serverCert = x509Certificate;
        this.prompt = "";
        this.addr = null;
        this.protocol = uRL.getProtocol();
        this.authType = Authenticator.RequestorType.PROXY;
        this.scheme = "";
    }
}

