/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -9095656433782481624L;
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int OK = 3;
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String prompt;
    private int messageType;
    private int optionType = -1;
    private int defaultOption;
    private String[] options;
    private int selection;

    public ConfirmationCallback(int n, int n2, int n3) {
        String string = ConfirmationCallback.doSanityCheck(n, n2, false, null, n3, null, false);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
        this.messageType = n;
        this.optionType = n2;
        this.defaultOption = n3;
    }

    public ConfirmationCallback(int n, String[] stringArray, int n2) {
        String string;
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
        }
        if ((string = ConfirmationCallback.doSanityCheck(n, -1, true, stringArray, n2, null, false)) != null) {
            throw new IllegalArgumentException(string);
        }
        this.messageType = n;
        this.defaultOption = n2;
        this.options = stringArray;
    }

    public ConfirmationCallback(String string, int n, int n2, int n3) {
        String string2 = ConfirmationCallback.doSanityCheck(n, n2, false, null, n3, string, true);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        this.prompt = string;
        this.messageType = n;
        this.optionType = n2;
        this.defaultOption = n3;
    }

    public ConfirmationCallback(String string, int n, String[] stringArray, int n2) {
        String string2;
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
        }
        if ((string2 = ConfirmationCallback.doSanityCheck(n, -1, true, stringArray, n2, string, true)) != null) {
            throw new IllegalArgumentException(string2);
        }
        this.prompt = string;
        this.messageType = n;
        this.defaultOption = n2;
        this.options = stringArray;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public void setSelectedIndex(int n) {
        this.selection = n;
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    private static String doSanityCheck(int n, int n2, boolean bl, String[] stringArray, int n3, String string, boolean bl2) {
        if (n < 0 || n > 2) {
            return "Invalid msgType";
        }
        if (bl2 && (string == null || string.isEmpty())) {
            return "Invalid prompt";
        }
        if (bl) {
            if (n2 != -1) {
                return "Invalid optionType";
            }
            if (stringArray == null || stringArray.length == 0 || n3 < 0 || n3 >= stringArray.length) {
                return "Invalid options and/or default option";
            }
            for (String string2 : stringArray) {
                if (string2 != null && !string2.isEmpty()) continue;
                return "Invalid option value";
            }
        } else {
            if (n2 < 0 || n2 > 2) {
                return "Invalid optionType";
            }
            if (n2 == 0 && n3 != 0 && n3 != 1 || n2 == 1 && n3 != 0 && n3 != 1 && n3 != 2 || n2 == 2 && n3 != 3 && n3 != 2) {
                return "Invalid default option";
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        objectInputStream.defaultReadObject();
        if (this.options != null) {
            this.options = (String[])this.options.clone();
        }
        if ((string = ConfirmationCallback.doSanityCheck(this.messageType, this.optionType, this.optionType == -1, this.options, this.defaultOption, this.prompt, false)) != null) {
            throw new InvalidObjectException(string);
        }
    }
}

