/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.Reference;
import java.util.function.Consumer;
import sun.misc.VM;

public class ReferenceQueue<T> {
    static ReferenceQueue<Object> NULL = new Null<Object>();
    static ReferenceQueue<Object> ENQUEUED = new Null<Object>();
    private Lock lock = new Lock();
    private volatile Reference<? extends T> head = null;
    private long queueLength = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference<? extends T> reference) {
        Lock lock = this.lock;
        synchronized (lock) {
            ReferenceQueue referenceQueue = reference.queue;
            if (referenceQueue == NULL || referenceQueue == ENQUEUED) {
                return false;
            }
            assert (referenceQueue == this);
            reference.next = this.head == null ? reference : this.head;
            this.head = reference;
            ++this.queueLength;
            reference.queue = ENQUEUED;
            if (reference instanceof FinalReference) {
                VM.addFinalRefCount(1);
            }
            this.lock.notifyAll();
            return true;
        }
    }

    private Reference<? extends T> reallyPoll() {
        Reference<? extends T> reference = this.head;
        if (reference != null) {
            reference.queue = NULL;
            Reference reference2 = reference.next;
            this.head = reference2 == reference ? null : reference2;
            reference.next = reference;
            --this.queueLength;
            if (reference instanceof FinalReference) {
                VM.addFinalRefCount(-1);
            }
            return reference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        if (this.head == null) {
            return null;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            return this.reallyPoll();
        }
    }

    public Reference<? extends T> remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference<T> reference = this.reallyPoll();
            if (reference != null) {
                return reference;
            }
            long l2 = l == 0L ? 0L : System.nanoTime();
            while (true) {
                this.lock.wait(l);
                reference = this.reallyPoll();
                if (reference != null) {
                    return reference;
                }
                if (l == 0L) continue;
                long l3 = System.nanoTime();
                if ((l -= (l3 - l2) / 1000000L) <= 0L) {
                    return null;
                }
                l2 = l3;
            }
        }
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    void forEach(Consumer<? super Reference<? extends T>> consumer) {
        Reference<? extends T> reference = this.head;
        while (reference != null) {
            consumer.accept(reference);
            Reference<? extends T> reference2 = reference.next;
            if (reference2 == reference) {
                if (reference.queue == ENQUEUED) {
                    reference = null;
                    continue;
                }
                reference = this.head;
                continue;
            }
            reference = reference2;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null<S>
    extends ReferenceQueue<S> {
        private Null() {
        }

        @Override
        boolean enqueue(Reference<? extends S> reference) {
            return false;
        }
    }
}

