/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Set;
import javax.crypto.SecretKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(RetrievalMethodResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod");
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, bl);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                if (x509Certificate != null) {
                    return x509Certificate.getPublicKey();
                }
                return null;
            }
            Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput, bl);
            if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                if (bl) {
                    if (LOG.isDebugEnabled()) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        LOG.debug(string3);
                    }
                    return null;
                }
                RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, bl);
                Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2, bl);
                if (element3 == element) {
                    LOG.debug("Error: Can't have RetrievalMethods pointing to each other");
                    return null;
                }
            }
            return RetrievalMethodResolver.resolveKey(element2, string, storageResolver, bl);
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            LOG.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            LOG.debug("IOException", iOException);
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string, bl);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                return RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
            }
            Element element2 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput, bl);
            if (XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
                if (bl) {
                    if (LOG.isDebugEnabled()) {
                        String string3 = "Error: It is forbidden to have one RetrievalMethod point to another with secure validation";
                        LOG.debug(string3);
                    }
                    return null;
                }
                RetrievalMethod retrievalMethod2 = new RetrievalMethod(element2, string);
                XMLSignatureInput xMLSignatureInput2 = RetrievalMethodResolver.resolveInput(retrievalMethod2, string, bl);
                Element element3 = RetrievalMethodResolver.obtainReferenceElement(xMLSignatureInput2, bl);
                if (element3 == element) {
                    LOG.debug("Error: Can't have RetrievalMethods pointing to each other");
                    return null;
                }
            }
            return RetrievalMethodResolver.resolveCertificate(element2, string, storageResolver, bl);
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            LOG.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            LOG.debug("IOException", iOException);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (element != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
            }
            return KeyResolver.getX509Certificate(element, string, storageResolver, bl);
        }
        return null;
    }

    private static PublicKey resolveKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (element != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
            }
            return KeyResolver.getPublicKey(element, string, storageResolver, bl);
        }
        return null;
    }

    private static Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput, boolean bl) throws CanonicalizationException, XMLParserException, IOException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else if (xMLSignatureInput.isNodeSet()) {
            element = RetrievalMethodResolver.getDocumentElement(xMLSignatureInput.getNodeSet());
        } else {
            byte[] byArray = xMLSignatureInput.getBytes();
            element = RetrievalMethodResolver.getDocFromBytes(byArray, bl);
            LOG.debug("we have to parse {} bytes", byArray.length);
        }
        return element;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, IOException, CertificateException {
        byte[] byArray = xMLSignatureInput.getBytes();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            return x509Certificate;
        }
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod retrievalMethod, String string, boolean bl) throws XMLSecurityException {
        Attr attr = retrievalMethod.getURIAttr();
        Transforms transforms = retrievalMethod.getTransforms();
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        XMLSignatureInput xMLSignatureInput = ResourceResolver.resolve(resourceResolverContext);
        if (transforms != null) {
            LOG.debug("We have Transforms");
            xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
        }
        return xMLSignatureInput;
    }

    @Override
    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    private static Element getDocumentElement(Set<Node> set) {
        Node node = null;
        for (Node object2 : set) {
            if (object2 == null || 1 != object2.getNodeType()) continue;
            node = (Element)object2;
            break;
        }
        ArrayList arrayList = new ArrayList();
        while (node != null) {
            arrayList.add(node);
            Node node2 = node.getParentNode();
            if (node2 == null || 1 != node2.getNodeType()) break;
            node = (Element)node2;
        }
        ListIterator listIterator = arrayList.listIterator(arrayList.size() - 1);
        Element element = null;
        while (listIterator.hasPrevious()) {
            element = (Element)listIterator.previous();
            if (!set.contains(element)) continue;
            return element;
        }
        return null;
    }
}

