/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;

    public SecretKeySpec(byte[] byArray, String string) {
        String string2 = SecretKeySpec.doSanityCheck(byArray, string);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("offset is negative");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("len is negative");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        if (this.algorithm.equalsIgnoreCase("TripleDES")) {
            return n ^= "desede".hashCode();
        }
        return n ^= this.algorithm.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.algorithm) || string.equalsIgnoreCase("DESede") && this.algorithm.equalsIgnoreCase("TripleDES") || string.equalsIgnoreCase("TripleDES") && this.algorithm.equalsIgnoreCase("DESede"))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return MessageDigest.isEqual(this.key, byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = SecretKeySpec.doSanityCheck(this.key, this.algorithm);
        if (string != null) {
            throw new InvalidObjectException(string);
        }
        byte[] byArray = this.key;
        this.key = (byte[])byArray.clone();
        Arrays.fill(byArray, (byte)0);
    }

    private static String doSanityCheck(byte[] byArray, String string) {
        String string2 = null;
        if (byArray == null || string == null) {
            string2 = "Missing argument";
        } else if (byArray.length == 0) {
            string2 = "Empty key";
        }
        return string2;
    }
}

